/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;

public final class RbfUtils {
    private RbfUtils() {
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static String getMachineInfo(MachineId machine) {
        InetAddress[] nicAddresses = machine.getNicAddresses();
        return machine.getName() + "/" + RbfUtils.getIpAddress(nicAddresses);
    }

    public static String getMachineInfo(Collection machines) {
        if (machines == null || machines.isEmpty()) {
            return null;
        }
        StringBuffer machineInfo = new StringBuffer();
        Iterator iterator = machines.iterator();
        while (iterator.hasNext()) {
            MachineId machine = (MachineId)iterator.next();
            InetAddress[] nicAddresses = machine.getNicAddresses();
            if (machineInfo.length() <= 0) {
                machineInfo.append(machine.getName() + "/" + RbfUtils.getIpAddress(nicAddresses));
                continue;
            }
            machineInfo.append(", " + machine.getName() + "/" + RbfUtils.getIpAddress(nicAddresses));
        }
        return machineInfo.toString();
    }

    private static String getIpAddress(InetAddress[] nicAddrs) {
        String ipAddr = "127.0.0.1";
        int i = 0;
        while (i < nicAddrs.length) {
            ipAddr = nicAddrs[i].getHostAddress();
            if (!ipAddr.startsWith("127.")) break;
            ++i;
        }
        return ipAddr;
    }

    public static String getLoggingInfo() {
        return RbfUtils.getLoggingInfo(null);
    }

    public static String getLoggingInfo(RbfRequest request) {
        HandlerManager handlerMgr = HandlerManager.getHandlerManager();
        FcsServer fcsServer = FcsServer.getFcsServer();
        StringBuffer sb = new StringBuffer();
        sb.append("Local Machine:\n");
        sb.append("rbfVersion=2\n");
        sb.append("machineId=" + fcsServer.getLocalMachineId());
        if (request != null) {
            sb.append("\n\nRequest:\n");
            sb.append(request.toDebugString());
        }
        if (request != null) {
            sb.append("\n\nRequest History:\n");
            sb.append(request.getTrackingData().getHistoryDump());
        }
        sb.append("\n\nRequest Handler Topology:\n");
        sb.append(handlerMgr.getHandlersDump(false));
        return sb.toString();
    }
}

